// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/common/resource_usage_reporter.mojom
//

package org.chromium.mojom;

class ResourceUsageReporter_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<ResourceUsageReporter, ResourceUsageReporter.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<ResourceUsageReporter, ResourceUsageReporter.Proxy>() {
    
        public String getName() {
            return "::ResourceUsageReporter";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, ResourceUsageReporter impl) {
            return new Stub(core, impl);
        }
    
        public ResourceUsageReporter[] buildArray(int size) {
          return new ResourceUsageReporter[size];
        }
    };

    private static final int GET_USAGE_DATA_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements ResourceUsageReporter.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void getUsageData(GetUsageDataResponse callback) {
            ResourceUsageReporterGetUsageDataParams _message = new ResourceUsageReporterGetUsageDataParams();
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_USAGE_DATA_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ResourceUsageReporterGetUsageDataResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<ResourceUsageReporter> {

        Stub(org.chromium.mojo.system.Core core, ResourceUsageReporter impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ResourceUsageReporter_Internal.MANAGER, messageWithHeader);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ResourceUsageReporter_Internal.MANAGER, messageWithHeader, receiver);
                    case GET_USAGE_DATA_ORDINAL: {
                        ResourceUsageReporterGetUsageDataParams.deserialize(messageWithHeader.getPayload());
                        getImpl().getUsageData(new ResourceUsageReporterGetUsageDataResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class ResourceUsageReporterGetUsageDataParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 8;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(8, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        private ResourceUsageReporterGetUsageDataParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ResourceUsageReporterGetUsageDataParams() {
            this(0);
        }
    
        public static ResourceUsageReporterGetUsageDataParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ResourceUsageReporterGetUsageDataParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ResourceUsageReporterGetUsageDataParams result = new ResourceUsageReporterGetUsageDataParams(mainDataHeader.elementsOrVersion);
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            return result;
        }
    }

    static final class ResourceUsageReporterGetUsageDataResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public ResourceUsageData data;
    
        private ResourceUsageReporterGetUsageDataResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ResourceUsageReporterGetUsageDataResponseParams() {
            this(0);
        }
    
        public static ResourceUsageReporterGetUsageDataResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ResourceUsageReporterGetUsageDataResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ResourceUsageReporterGetUsageDataResponseParams result = new ResourceUsageReporterGetUsageDataResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.data = ResourceUsageData.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(data, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ResourceUsageReporterGetUsageDataResponseParams other = (ResourceUsageReporterGetUsageDataResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.data, other.data))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(data);
            return result;
        }
    }

    static class ResourceUsageReporterGetUsageDataResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final ResourceUsageReporter.GetUsageDataResponse mCallback;

        ResourceUsageReporterGetUsageDataResponseParamsForwardToCallback(ResourceUsageReporter.GetUsageDataResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(GET_USAGE_DATA_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                ResourceUsageReporterGetUsageDataResponseParams response = ResourceUsageReporterGetUsageDataResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.data);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ResourceUsageReporterGetUsageDataResponseParamsProxyToResponder implements ResourceUsageReporter.GetUsageDataResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ResourceUsageReporterGetUsageDataResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(ResourceUsageData data) {
            ResourceUsageReporterGetUsageDataResponseParams _response = new ResourceUsageReporterGetUsageDataResponseParams();
            _response.data = data;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    GET_USAGE_DATA_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

